# Install Checklist Tracking 
# Copyright 2004, 2006 by Brian C. Christensen

#    This file is part of GanttPV.
#
#    GanttPV is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    GanttPV is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with GanttPV; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# 041117 - first draft of program based on Install Follow Up Tracking
# 041218 - minor change in sequence of fields
# 060830 - added suggested columns and updated labels

# These design notes are intended to explore the problem. They include more than will be 
#   implemented in the initial version.

# Follow up items can also be issues or action items.

# CheckList Table
#	- Sequence
#	- Name
#	- EffortHours
#	- ActualEndDate
#	- Notes

#	- Category
#	- Resolution
#	- DateAdded
#	- Reference

# This script must be run against each file to include the new report options.

# If you want to make sure the report types and column types you add don't conflict
#    with new releases of GanttPV, prefix the Name with "xx". For
#    example: "xxDocument", "xxOwner", "xxURL", etc.

debug = 1

def DoAdd():
    # Specified all required Report Types and Column Types
    # It will either add them or update them if they already exist.

    rt = { 'Name': 'Task' }  
    ct = [
    { 'Name': 'Notes',        'Label': 'Notes',             'DataType': 't', 'AccessType': 'd', 'T': 'A', 'Edit': True,  'Width': 140  },
         ]
    Data.AddReportType(rt, ct)

    rt = { 'Name': 'Task/Checklist', 'TableA': 'Task', 'TableB': 'Checklist', 'Also': 'Task', 'AllOrEach': 'Each',
#            'SuggestedColumns': 'Task,Name;Task,ResourceNames;Task,DurationHours;Task,EffortHours;Task,CalculatedStartDate;Task,CalculatedEndDate;,Sequence;,Name;,EffortHours;,ActualEndDate;,Notes;,DateAdded' }  
            'SuggestedColumns': 'Task,Name;Task,CalculatedStartDate;Task,CalculatedEndDate;,Sequence;,Name;,ActualEndDate;,Notes;,DateAdded' }  
    ct = [
    { 'Name': 'ID',           'Label': None,              'DataType': 'i', 'AccessType': 'd', 'T': 'B', 'Edit': False, 'Width': 35  },
    { 'Name': 'Sequence',     'Label': 'Seq',             'DataType': 'i', 'AccessType': 'd', 'T': 'B', 'Edit': True,  'Width': 35  },
    { 'Name': 'Name',         'Label': 'Checklist Item', 'DataType': 't', 'AccessType': 'd', 'T': 'B', 'Edit': True,  'Width': 180  },
    { 'Name': 'EffortHours',  'Label': 'Expected\nEffort','DataType':'f', 'AccessType': 'd', 'T': 'B', 'Edit': True,  'Width': 80  },
    { 'Name': 'Notes',        'Label': 'Checklist\nNotes','DataType': 't', 'AccessType': 'd', 'T': 'B', 'Edit': True,  'Width': 140  },
    { 'Name': 'ActualEndDate','Label': 'Actual\nEnd Date','DataType': 'd', 'AccessType': 'd', 'T': 'B', 'Edit': True,  'Width': 80  },
    { 'Name': 'DateAdded',    'Label': 'Date\nAdded',     'DataType': 'd', 'AccessType': 'd', 'T': 'B', 'Edit': True,  'Width': 80  },

#    { 'Name': 'Category',     'Label': None,             'DataType': 't', 'AccessType': 'd', 'T': 'A', 'Edit': True,  'Width': 60  },
#    { 'Name': 'Resolution',   'Label': None,             'DataType': 't', 'AccessType': 'd', 'T': 'A', 'Edit': True,  'Width': 120  },
#    { 'Name': 'DateResolved', 'Label': 'Date\nResolved', 'DataType': 'd', 'AccessType': 'd', 'T': 'A', 'Edit': True,  'Width': 80  },
#    { 'Name': 'Reference',    'Label': None,             'DataType': 't', 'AccessType': 'd', 'T': 'A', 'Edit': True,  'Width': 100  },
        ]
    Data.AddReportType(rt, ct)

    Data.SetUndo("Install Task Checklist Tracking")

DoAdd()
